/**
 *
 */
package gov.va.med.mhv.usermgmt.util;

import java.util.Map;

import gov.va.med.mhv.core.util.Precondition;
import gov.va.med.mhv.usermgmt.enumeration.ExtractType;

/**
 * @author Rob Proper (Aquilent Inc.)
 *
 */
public final class ExtractTypeUtils {

    public static final ExtractType CHEMISTRYHEMATOLOGY =
        ExtractType.getEnum(ExtractType.CHEMISTRYHEMATOLOGY);

    public static final ExtractType ALLERGY =
        ExtractType.getEnum(ExtractType.ALLERGY);

    public static final ExtractType VBHHANDBOOK =
        ExtractType.getEnum(ExtractType.VBHHANDBOOK);

    public static final ExtractType APPOINTMENTS =
        ExtractType.getEnum(ExtractType.APPOINTMENTS);

    public static boolean isChemistryHematology(ExtractType extractType) {
        Precondition.assertNotNull("extractType", extractType);
        return CHEMISTRYHEMATOLOGY.equals(extractType);
    }

    public static boolean isAllergy(ExtractType extractType) {
        Precondition.assertNotNull("extractType", extractType);
        return ALLERGY.equals(extractType);
    }

    public static boolean isVbhHandbook(ExtractType extractType) {
        Precondition.assertNotNull("extractType", extractType);
        return VBHHANDBOOK.equals(extractType);
    }

    public static boolean isAppointments(ExtractType extractType) {
        Precondition.assertNotNull("extractType", extractType);
        return APPOINTMENTS.equals(extractType);
    }

    public static boolean isAppointments(String extractType) {
        Precondition.assertNotNull("extractType", extractType);
        return APPOINTMENTS.getName().equals(extractType);
    }

    @SuppressWarnings("unchecked")
	public static ExtractType[] getAllExtractTypes() {
        Map extractTypeMap = ExtractType.getEnumMap();
        ExtractType[] extractTypes = null;
        if (extractTypeMap != null) {
        	extractTypes = new ExtractType[(extractTypeMap.size())];
        	extractTypeMap.values().toArray(extractTypes); // "unchecked"
        }
    	// Could make the resulting value a static final field, however,
        // it would be mutable (the array would be immutable,
        // but not its values contained in the array).
        // The array would have to be immutable, such that clients cannot change
        // its values.
        // To make it immutable a copies would have to be made every time,
        // which would negate the benefit of making it a static final variable
    	return extractTypes;
    }

    private ExtractTypeUtils() {
    }

}
